//---------------------------------------------------------------------------

#ifndef MainFormH
#define MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ActnList.hpp>
#include <StdActns.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include <System.Actions.hpp>
//---------------------------------------------------------------------------
class TfrmMain : public TForm
{
__published:	// IDE-managed Components
	TStatusBar *barStatus;
	TMemo *mmoEditor;
	TActionList *actMain;
	TMainMenu *mnuMain;
	TMenuItem *mnuFile;
	TMenuItem *mnuFileOpen;
	TFileSaveAs *actFileSaveAs;
	TAction *actFileNew;
	TAction *actFileExit;
	TMenuItem *mnuFileNew;
	TMenuItem *mnuFileSaveAs;
	TMenuItem *N1;
	TMenuItem *mnuFileExit;
	TMenuItem *mnuFileSave;
	TAction *actFileOpen;
	TOpenDialog *dlgFileOpen;
	TAction *actFileSave;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall actFileSaveAsAccept(TObject *Sender);
	void __fastcall actFileNewExecute(TObject *Sender);
	void __fastcall actFileExitExecute(TObject *Sender);
	void __fastcall mmoEditorChange(TObject *Sender);
	void __fastcall FormResize(TObject *Sender);
	void __fastcall mmoEditorKeyUp(TObject *Sender, WORD &Key, TShiftState Shift);
	void __fastcall FormKeyDown(TObject *Sender, WORD &Key, TShiftState Shift);
	void __fastcall actFileOpenExecute(TObject *Sender);
	void __fastcall actFileSaveExecute(TObject *Sender);

private:
	AnsiString AppName_;  // Text to be displayed in the title bar
	AnsiString Filename_; // File name of the currently opened document
	bool Dirty_;          // State of the open document

		// These are fairly self-explanatory and you can learn more
		// from the comments in the .cpp file
	bool LoadFile(const AnsiString &filename);
	bool SaveFile(const AnsiString &filename);
	bool CheckAndSave(void);
	void UpdateTitleBar(void);
	void UpdateStatusBar(void);
	void FormatCaretPos(void);

public:
		// Constructor
	__fastcall TfrmMain(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmMain *frmMain;
//---------------------------------------------------------------------------
#endif
